%% plot2d2.m 

%% Two-dimensional pictorial representation for a type-2 set
%% for which a principal membership function can be  defined. 
%% The secondary membership function corrresponding to every
%% domain point is assumed to increase from the lower MF to 
%% the principal membership function, and decrease from the
%% principal membership function to the upper MF. This function
%% shades the area between the principal membership function and the 
%% upper and lower MFs in such a way that the intensity of shading 
%% increases from the brightest at the lower MF to the darkest at 
%% the principal membership function and then decreases again to the 
%% brightest at the upper MF. See Fig. 3-4(a) in the book Uncertain Rule-Based 
%% Fuzzy Logic Systems: Introduction and New Directions, by Jerry M. Mendel, 
%% and published by Prentice-Hall, 2000, for an example. 

%% Written by Nilesh N. Karnik - August 18,1998
%% For use with MATLAB version 4.2c (may not work with
%% later versions of MATLAB)

%% Outputs : None. The function plots the required type-2 set in the 
%% active figure window.

%% Inputs : "principal", "upper", "lower" and "xaxis" are all vectors 
%% having the same length. "principal", "upper" and "lower", 
%% contain  the y-coordinates of the principal membership function, 
%% the upper bound and the lower bound, respectively; and, "xaxis" 
% contains the x-coordinates of these functions.
 
%% For example, a figure like Fig. 3-4(a) can be generated using the following script :
 
%%      xaxis = [0 : 0.05 : 6] ;
%%      principal = exp(-0.5*(xaxis-3).^2) ;
%%      upper = min(1,1.3*principal) ;
%%      lower = 0.7*principal ;
%%      plot2d2(principal,upper,lower,xaxis) ;
 
%% NOTE 1 : If the stepsize for the x-coordinates is too fine, the 
%% shading may not be visible.

%% NOTE 2 : If lighter shading is desired, the value of "map_start" 
%% should be increased ("map_start < 1"). 


function [] = plot2d2(principal, upper, lower, xaxis) 

map_start = 0 ;      %% Starting (darkest) RGB values for the grey shades.

color_step = 0.05 ;     %% stepsize for the colormap.

t = [map_start : color_step : 1]' ;

lt = length(t) ;

map = [t  t  t] ;



lx = length(xaxis) ;

y_upper1 = upper(1:lx-1) ;
y_upper2 = upper(2:lx) ;
y_principal1    = principal(2:lx) ;
y_principal2    = principal(1:lx-1) ;

xaxis1 = xaxis(1:lx-1) ;
xaxis2 = xaxis(2:lx) ;

y1 = [ y_upper1' y_upper2'  y_principal1' y_principal2' ]' ;
x1 = [ xaxis1' xaxis2' xaxis2' xaxis1']' ;
 
o1 = ones(size(xaxis1)) ;
ct1 = lt*o1 ;

c = [ct1' ct1' o1' o1']' ;

y_lower1 = lower(1:lx-1) ;
y_lower2 = lower(2:lx) ;

y2 = [y_lower1' y_lower2'  y_principal1' y_principal2' ]' ;


plot(xaxis,principal) ;

hold on ;

colormap(map) ;


fill(x1,y1,c,x1,y2,c) ;

plot(xaxis,principal,'linewidth',1) ;


return ;
